<?php

/**
 * @since 1.5.0
 */
class CashBillValidationModuleFrontController extends ModuleFrontController
{
    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {

        $cart = $this->context->cart;
        $amount = (float)$cart->getOrderTotal(true, Cart::BOTH);
        if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        $customer = new Customer($cart->id_customer);
        if (!Validate::isLoadedObject($customer)) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        // Check that this payment option is still available in case the customer changed his address just before the end of the checkout process
        $authorized = false;
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'cashbill') {
                $authorized = true;
                break;
            }
        }

        if (!$authorized) {
            die($this->module->l('Metoda płatności jest niedostępna.', 'validation'));
        }

        $this->context->smarty->assign([
            'params' => $_REQUEST,
        ]);

        $currency = $this->context->currency;

        $this->module->validateOrder($cart->id, Configuration::get('PAYMENT_CASHBILL_NEW_STATUS'), $amount, $this->module->displayName, null, null, (int)$currency->id, false, $customer->secure_key);

        $returnUrl = Context::getContext()->shop->getBaseURL(true) . 'index.php?controller=order-confirmation&id_cart=' . $cart->id . '&id_module=' . $this->module->id . '&id_order=' . $this->module->currentOrder . '&key=' . $customer->secure_key;
        $negativeReturnUrl = $this->context->link->getModuleLink('cashbill', 'payment-error');
        $orderId = $this->module->currentOrder;
        $address = new Address($cart->id_address_invoice);

        $title = Configuration::get('PS_SHOP_NAME');
        $description = $this->l("Zamówienie #") . Order::getUniqReferenceOf($orderId);
        $additionalData = $orderId;
        $languageCode = Language::getIsoById($cart->id_lang);
        $referer = "PrestaShop";
        $firstName = $customer->firstname;
        $surname = $customer->lastname;
        $email = $customer->email;
        $country = $address->country;
        $city = $address->city;
        $postcode = $address->postcode;
        $street = $address->address1;
        $paymentChannel = Tools::getValue("paymentChannel") ? Tools::getValue("paymentChannel") : "";

        $secretPhrase =  Configuration::get('CB_SECRET_PHRASE');

        $sign = sha1($title . $amount . $currency->iso_code . $returnUrl . $description . $negativeReturnUrl
            . $additionalData . $paymentChannel . $languageCode . $referer . $firstName . $surname
            . $email . $country . $city . $postcode . $street . $secretPhrase);

        $mainUrl = Configuration::get('CB_TEST_MODE') ? CashBill::CB_TEST_URL : CashBill::CB_MAIN_URL;
        $shopId = Configuration::get('CB_ID');

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_URL => "{$mainUrl}/payment/{$shopId}",
            CURLOPT_POSTFIELDS => http_build_query(array(
                "title" => $title,
                "amount.value" => $amount,
                "amount.currencyCode" => $currency->iso_code,
                "returnUrl" => $returnUrl,
                "negativeReturnUrl" => $negativeReturnUrl,
                "sign" => $sign,
                "description" => $description,
                "additionalData" => $additionalData,
                "languageCode" => $languageCode,
                "paymentChannel" => $paymentChannel,
                "referer" => $referer,
                "personalData.firstName" => $firstName,
                "personalData.surname" => $surname,
                "personalData.email" => $email,
                "personalData.country" => $country,
                "personalData.city" => $city,
                "personalData.postcode" => $postcode,
                "personalData.street" => $street,
            ))
        ));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("Content-Type: application/x-www-form-urlencoded; charset=UTF-8"));
        $out = curl_exec($ch);

        if (curl_getinfo($ch, CURLINFO_HTTP_CODE) != 200) {
            curl_close($ch);
            throw new Exception($out);
        }
        curl_close($ch);

        $newPayment = json_decode($out);

        Tools::redirect($newPayment->redirectUrl);
    }
}
