<?php

/**
 * @since 1.5.0
 */
class CashBillNotifyModuleFrontController extends ModuleFrontController
{
    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {

        $cmd = $_REQUEST['cmd'];
        $args = $_REQUEST['args'];
        $sign = $_REQUEST['sign'];

        $secretPhrase = Configuration::get('CB_SECRET_PHRASE');

        if ($sign != md5($cmd . $args . $secretPhrase)) {
            exit("SIGNATURE ERROR");
        }

        try {
            switch ($cmd) {
                case 'transactionStatusChanged':
                    if ($this->eventTransactionStatusChanged($args)) {
                        exit("OK");
                    } else {
                        exit("ERROR");
                    }
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }

        exit("OK");
    }

    public function eventTransactionStatusChanged($id)
    {
        $transaction = CashBill::getPayment($id);
        $order_id = $transaction->additionalData;

        if ($order_id) {
            if (in_array($transaction->status, array("PositiveFinish", "Abort", "NegativeAuthorization"))) {
                $history = new OrderHistory();
                $history->id_order = $order_id;
                $order = new Order((int) $order_id);

                $isPositive = $transaction->status === "PositiveFinish";
                $nextStatus =  $isPositive ? Configuration::get('PAYMENT_CASHBILL_SUCCESS_STATUS') : Configuration::get('PAYMENT_CASHBILL_ERROR_STATUS');

                $statusHistory = $order->getHistory($order->id_lang, $nextStatus);

                if ($statusHistory && count($statusHistory) > 0) {
                    return true;
                }

                if ($isPositive) {
                    $order->addOrderPayment($transaction->amount->value, 'Płatności CashBill', $transaction->id);
                }
                $history->changeIdOrderState($nextStatus, $order_id, $isPositive);
                $history->addWithemail(true);
            }

            return true;
        }

        return false;
    }
}
