<?php

use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if (!defined('_PS_VERSION_')) {
    exit;
}

class CashBill extends PaymentModule
{
    protected $_html = '';
    protected $_postErrors = array();

    public $details;
    public $owner;
    public $address;
    public $extra_mail_vars;

    const CB_MAIN_URL = "https://pay.cashbill.pl/ws/rest";
    const CB_TEST_URL = "https://pay.cashbill.pl/testws/rest";

    public function __construct()
    {
        $this->name = 'cashbill';
        $this->tab = 'payments_gateways';
        $this->version = '1.5.0';
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->author = 'CashBill S.A.';
        $this->controllers = array('validation', 'notify');
        $this->is_eu_compatible = 1;

        $this->currencies = true;
        $this->currencies_mode = 'checkbox';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Płatności CashBill');
        $this->description = $this->l('Błyskawiczne płatności dla Twojego sklepu internetowego!');

        if (!count(Currency::checkPaymentCurrencies($this->id))) {
            $this->warning = $this->l('Brak walut ustawionych dla tego modułu!');
        }
    }

    public function install()
    {
        if (
            !parent::install() || !$this->registerHook('paymentOptions') || !$this->registerHook('paymentReturn') || !Configuration::updateValue('CB_ID', '') ||
            !Configuration::updateValue('CB_SECRET_PHRASE', '') ||
            !Configuration::updateValue('CB_TEST_MODE', true) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_PBL', false) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_BLIK', false) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_GOOGLEPAYAPPLEPAY', false) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_CARD', false) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_PAYPAL', false) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_PSC', false) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_INSTALLMENT', false) ||
            !Configuration::updateValue('CB_PAYMENTCHANNEL_TWISTO', false) ||
            !Configuration::updateValue('PAYMENT_CASHBILL_SUCCESS_STATUS', Configuration::get('PS_OS_PAYMENT')) ||
            !Configuration::updateValue('PAYMENT_CASHBILL_ERROR_STATUS', Configuration::get('PS_OS_CANCELED'))
        ) {
            return false;
        }

        if (Validate::isInt(Configuration::get('PAYMENT_CASHBILL_NEW_STATUS')) xor (Validate::isLoadedObject($order_state_new = new OrderState(Configuration::get('PAYMENT_CASHBILL_NEW_STATUS'))))) {
            $order_state_new = new OrderState();
            $order_state_new->name[Language::getIdByIso("pl")] = "Oczekuje potwierdzenia płatności";
            $order_state_new->name[Language::getIdByIso("en")] = "Awaiting payment confirmation";
            $order_state_new->send_email = false;
            $order_state_new->invoice = false;
            $order_state_new->unremovable = false;
            $order_state_new->color = "lightblue";
            if (!$order_state_new->add()) {
                return false;
            }
            if (!Configuration::updateValue('PAYMENT_CASHBILL_NEW_STATUS', $order_state_new->id)) {
                return false;
            }
        }

        return true;
    }

    public function hookPaymentReturn()
    {
    }

    public function hookPaymentOptions($params)
    {
        if (!$this->active) {
            return;
        }

        if (!$this->checkCurrency($params['cart'])) {
            return;
        }

        $payment_options = $this->getExternalPaymentOption();

        return $payment_options;
    }

    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);

        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }
        return false;
    }

    public function getExternalPaymentOption()
    {
        $cart = $this->context->cart;
        $amount = (float)$cart->getOrderTotal(true, Cart::BOTH);

        $externalOption = array();

        if (Configuration::get('CB_PAYMENTCHANNEL_PBL')) {
            $defaultOption = new PaymentOption();
            $defaultOption->setCallToActionText($this->l('Natychmiastowe płatności internetowe'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true));

            $externalOption[] = $defaultOption;
        }

        if (Configuration::get('CB_PAYMENTCHANNEL_BLIK')) {
            $additionalOptionBlik = new PaymentOption();
            $additionalOptionBlik->setCallToActionText($this->l('Płatność BLIK'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "blik"), true));

            $externalOption[] = $additionalOptionBlik;
        }

        if (Configuration::get('CB_PAYMENTCHANNEL_GOOGLEPAYAPPLEPAY')) {
            $additionalOptionApplePay = new PaymentOption();
            $additionalOptionApplePay->setCallToActionText($this->l('Płatność Apple Pay'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "applepay"), true));

            $additionalOptionGooglePay = new PaymentOption();
            $additionalOptionGooglePay->setCallToActionText($this->l('Płatność Google Pay'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "googlepay"), true));

            $externalOption[] = $additionalOptionApplePay;
            $externalOption[] = $additionalOptionGooglePay;
        }

        if (Configuration::get('CB_PAYMENTCHANNEL_CARD')) {
            $additionalOptionCard = new PaymentOption();
            $additionalOptionCard->setCallToActionText($this->l('Płatność kartą'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "polcard"), true));

            $externalOption[] = $additionalOptionCard;
        }

        if (Configuration::get('CB_PAYMENTCHANNEL_PAYPAL')) {
            $additionalOptionPaypal = new PaymentOption();
            $additionalOptionPaypal->setCallToActionText($this->l('Płatność PayPal'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "paypal"), true));

            $externalOption[] = $additionalOptionPaypal;
        }

        if (Configuration::get('CB_PAYMENTCHANNEL_PSC')) {
            $additionalOptionPsc = new PaymentOption();
            $additionalOptionPsc->setCallToActionText($this->l('Płatność Paysafecard'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "paysafecard"), true));

            $externalOption[] = $additionalOptionPsc;
        }

        if (Configuration::get('CB_PAYMENTCHANNEL_INSTALLMENT') && $amount >= 300.00 && $amount <= 20000.00) {
            $additionalOptionInstallment = new PaymentOption();
            $additionalOptionInstallment->setCallToActionText($this->l('Płatność ratalna'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "aliorraty"), true));

            $externalOption[] = $additionalOptionInstallment;
        }

        if (Configuration::get('CB_PAYMENTCHANNEL_TWISTO') && $amount <= 500.00) {
            $additionalOptionTwisto = new PaymentOption();
            $additionalOptionTwisto->setCallToActionText($this->l('Płatność odroczona Twisto'))
                ->setAction($this->context->link->getModuleLink($this->name, 'validation', array('paymentChannel' => "twisto"), true));

            $externalOption[] = $additionalOptionTwisto;
        }


        return $externalOption;
    }

    public function isPropValid($prop)
    {
        return $prop && !empty($prop);
    }

    public function getContent()
    {
        $output = null;

        if (Tools::isSubmit('submit' . $this->name)) {
            $cb_id = strval(Tools::getValue('CB_ID'));
            $cb_secret = strval(Tools::getValue('CB_SECRET_PHRASE'));
            $cb_mode = strval(Tools::getValue('CB_TEST_MODE'));
            $pc_pbl = strval(Tools::getValue('CB_PAYMENTCHANNEL_PBL'));
            $pc_blik = strval(Tools::getValue('CB_PAYMENTCHANNEL_BLIK'));
            $pc_googleapple = strval(Tools::getValue('CB_PAYMENTCHANNEL_GOOGLEPAYAPPLEPAY'));
            $pc_card = strval(Tools::getValue('CB_PAYMENTCHANNEL_CARD'));
            $pc_paypal = strval(Tools::getValue('CB_PAYMENTCHANNEL_PAYPAL'));
            $pc_psc = strval(Tools::getValue('CB_PAYMENTCHANNEL_PSC'));
            $pc_installment = strval(Tools::getValue('CB_PAYMENTCHANNEL_INSTALLMENT'));
            $pc_twisto = strval(Tools::getValue('CB_PAYMENTCHANNEL_TWISTO'));
            $status_success = intval(Tools::getValue('PAYMENT_CASHBILL_SUCCESS_STATUS'));
            $status_error = intval(Tools::getValue('PAYMENT_CASHBILL_ERROR_STATUS'));

            if ($this->isPropValid($cb_id) && $this->isPropValid($cb_secret)) {
                Configuration::updateValue('CB_ID', $cb_id);
                Configuration::updateValue('CB_SECRET_PHRASE', $cb_secret);
                Configuration::updateValue('CB_TEST_MODE', $cb_mode ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_PBL', $pc_pbl ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_BLIK', $pc_blik ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_GOOGLEPAYAPPLEPAY', $pc_googleapple ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_CARD', $pc_card ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_PAYPAL', $pc_paypal ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_PSC', $pc_psc ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_INSTALLMENT', $pc_installment ? true : false);
                Configuration::updateValue('CB_PAYMENTCHANNEL_TWISTO', $pc_twisto ? true : false);
                Configuration::updateValue('PAYMENT_CASHBILL_SUCCESS_STATUS', $status_success);
                Configuration::updateValue('PAYMENT_CASHBILL_ERROR_STATUS', $status_error);

                $output .= $this->displayConfirmation($this->l('Ustawienia zaktualizowane.'));
            } else {
                $output .= $this->displayError($this->l('Wypełnij poprawnie wszystkie pola.'));
            }
        }
        return $output . $this->displayForm();
    }

    public function displayForm()
    {
        // Get default language
        $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');

        $orderStatesData = OrderState::getOrderStates($default_lang);
        $orderStates = array();
        foreach ($orderStatesData as $state) {
            $orderStates[] = array(
                'id_order_state' => $state['id_order_state'],
                'name' => $state['name']
            );
        }

        // Init Fields form array
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Ustawienia'),
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Identyfikator Punktu Płatności'),
                    'name' => 'CB_ID',
                    'size' => 20,
                    'required' => true
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Klucz Punktu Płatności'),
                    'name' => 'CB_SECRET_PHRASE',
                    'size' => 20,
                    'required' => true
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Tryb Testowy Włączony'),
                    'name' => 'CB_TEST_MODE',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type'    => 'select',
                    'label'   => $this->l('Status opłacone zamówienia'),
                    'name'    => 'PAYMENT_CASHBILL_SUCCESS_STATUS',
                    'options' => array(
                        'query' => $orderStates,
                        'id'    => 'id_order_state',
                        'name'  => 'name'
                    )
                ),
                array(
                    'type'    => 'select',
                    'label'   => $this->l('Status anulowanego zamówienia'),
                    'name'    => 'PAYMENT_CASHBILL_ERROR_STATUS',
                    'options' => array(
                        'query' => $orderStates,
                        'id'    => 'id_order_state',
                        'name'  => 'name'
                    )
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl Płatności PBL w koszyku'),
                    'desc' => $this->l('Płatności PBL zostaną wyświetlone na równi z innymi formami płatności w koszyku sklepu.'),
                    'name' => 'CB_PAYMENTCHANNEL_PBL',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl BLIK w koszyku'),
                    'desc' => $this->l('BLIK zostanie wyświetlony na równi z innymi formami płatności w koszyku sklepu.'),
                    'name' => 'CB_PAYMENTCHANNEL_BLIK',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl Google Pay i Apple Pay w koszyku'),
                    'desc' => $this->l('Google Pay i Apple Pay zostanie wyświetlony na równi z innymi formami płatności w koszyku sklepu. Google Pay i Apple Pay musi być aktywny w panelu klienta CashBill.'),
                    'name' => 'CB_PAYMENTCHANNEL_GOOGLEPAYAPPLEPAY',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl karty płatnicze w koszyku'),
                    'desc' => $this->l('Karty płatnicze zostaną wyświetlone na równi z innymi formami płatności w koszyku sklepu. Karty płatnicze muszą być aktywne w panelu klienta CashBill.'),
                    'name' => 'CB_PAYMENTCHANNEL_CARD',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl PayPal w koszyku'),
                    'desc' => $this->l('Paypal zostanie wyświetlony na równi z innymi formami płatności w koszyku sklepu. Paypal musi być aktywne w panelu klienta CashBill.'),
                    'name' => 'CB_PAYMENTCHANNEL_PAYPAL',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl Paysafecard w koszyku'),
                    'desc' => $this->l('Paysafecard zostanie wyświetlony na równi z innymi formami płatności w koszyku sklepu. Paysafecard musi być aktywny w panelu klienta CashBill.'),
                    'name' => 'CB_PAYMENTCHANNEL_PSC',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl płatności ratalne w koszyku'),
                    'desc' => $this->l('Paypal zostanie wyświetlony na równi z innymi formami płatności w koszyku sklepu. Płatności ratalne musi być aktywne w panelu klienta CashBill.'),
                    'name' => 'CB_PAYMENTCHANNEL_INSTALLMENT',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Wyświetl Twisto w koszyku'),
                    'desc' => $this->l('Twisto zostanie wyświetlony na równi z innymi formami płatności w koszyku sklepu. Twisto musi być aktywne w panelu klienta CashBill.'),
                    'name' => 'CB_PAYMENTCHANNEL_TWISTO',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Tak')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Nie')
                        )
                    ),
                ),

            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right'
            )
        );

        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;

        // Language
        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;

        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;        // false -> remove toolbar
        $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
        $helper->submit_action = 'submit' . $this->name;
        $helper->toolbar_btn = array(
            'save' =>
            array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex . '&configure=' . $this->name . '&save' . $this->name .
                    '&token=' . Tools::getAdminTokenLite('AdminModules'),
            ),
            'back' => array(
                'href' => AdminController::$currentIndex . '&token=' . Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            )
        );

        // Load current value
        $helper->fields_value['CB_ID'] = Configuration::get('CB_ID');
        $helper->fields_value['CB_SECRET_PHRASE'] = Configuration::get('CB_SECRET_PHRASE');
        $helper->fields_value['CB_TEST_MODE'] = Configuration::get('CB_TEST_MODE');
        $helper->fields_value['CB_PAYMENTCHANNEL_PBL'] = Configuration::get('CB_PAYMENTCHANNEL_PBL');
        $helper->fields_value['CB_PAYMENTCHANNEL_BLIK'] = Configuration::get('CB_PAYMENTCHANNEL_BLIK');
        $helper->fields_value['CB_PAYMENTCHANNEL_GOOGLEPAYAPPLEPAY'] = Configuration::get('CB_PAYMENTCHANNEL_GOOGLEPAYAPPLEPAY');
        $helper->fields_value['CB_PAYMENTCHANNEL_CARD'] = Configuration::get('CB_PAYMENTCHANNEL_CARD');
        $helper->fields_value['CB_PAYMENTCHANNEL_PAYPAL'] = Configuration::get('CB_PAYMENTCHANNEL_PAYPAL');
        $helper->fields_value['CB_PAYMENTCHANNEL_PSC'] = Configuration::get('CB_PAYMENTCHANNEL_PSC');
        $helper->fields_value['CB_PAYMENTCHANNEL_INSTALLMENT'] = Configuration::get('CB_PAYMENTCHANNEL_INSTALLMENT');
        $helper->fields_value['CB_PAYMENTCHANNEL_TWISTO'] = Configuration::get('CB_PAYMENTCHANNEL_TWISTO');
        $helper->fields_value['PAYMENT_CASHBILL_SUCCESS_STATUS'] = Configuration::get('PAYMENT_CASHBILL_SUCCESS_STATUS');
        $helper->fields_value['PAYMENT_CASHBILL_ERROR_STATUS'] = Configuration::get('PAYMENT_CASHBILL_ERROR_STATUS');

        return $helper->generateForm($fields_form);
    }

    public static function getPayment($id)
    {
        $mainUrl = Configuration::get('CB_TEST_MODE') ? self::CB_TEST_URL : self::CB_MAIN_URL;
        $shopId = Configuration::get('CB_ID');
        $secretPhrase = Configuration::get('CB_SECRET_PHRASE');

        $sign = sha1($id . $secretPhrase);

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_URL => "{$mainUrl}/payment/{$shopId}/{$id}?sign={$sign}",
        ));

        $out = curl_exec($ch);

        if (curl_getinfo($ch, CURLINFO_HTTP_CODE) != 200) {
            curl_close($ch);
            throw new Exception($out);
        }
        curl_close($ch);

        return json_decode($out);
    }
}
