<?php

namespace Opencart\Catalog\Controller\Extension\CashBill\Payment;
use Opencart\System\Engine\Controller;

class CashBill extends Controller
{
    const OK_STATUS = "OK";

    public function index()
    {
        $this->language->load('extension/cashbill/payment/cashbill');

        if (isset($this->session->data['payment_method'])) {
            $data['button_confirm'] = $this->language->get('button_confirm');
            $data['cashbill_action'] = $this->url->link('extension/cashbill/payment/cashbill.pay', '', true);
            return $this->load->view('extension/cashbill/payment/cashbill', $data);
        }

        return '';
    }

    public function pay()
    {
        $this->load->model('checkout/order');
        $this->language->load('extension/cashbill/payment/cashbill');

        $orderID = $this->session->data['order_id'];
        $order_info = $this->model_checkout_order->getOrder($orderID);

        $secret = $this->config->get('payment_cashbill_secret');

        $data['clientData'] = array(
            'service' => $this->config->get('payment_cashbill_pp'),
            'amount' => $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false),
            'currency' => $order_info['currency_code'],
            'desc' => $this->language->get('payment_description') . ' [' . $orderID . ']',
            'lang' => "",
            'userdata' => $orderID,
            'ref' => 'OpenCart-3',
            'forname' => $order_info['payment_firstname'],
            'surname' => $order_info['payment_lastname'],
            'email' => $order_info['email'],
            'tel' => $order_info['telephone'],
            'street' => $order_info['payment_address_1'],
            'street_n1' => $order_info['payment_address_2'],
            'street_n2' => '',
            'city' => $order_info['payment_city'],
            'postcode' => $order_info['payment_postcode'],
            'country' => $order_info['payment_country']
        );

        $data['clientData']['sign'] = md5(implode("|", $data['clientData']) . '|' . $secret);

        try {

            if ($order_info['order_status_id'] != $this->config->get('payment_cashbill_order_status_new_id')) {
                $message = 'Rozpoczęcie płatności dla zamówienia o nr. ' . $orderID . ' w serwisie CashBill';
                $this->model_checkout_order->addHistory($orderID, $this->config->get('payment_cashbill_order_status_new_id'), $message, false);
            }

            if (isset($this->session->data['order_id'])) {
                $this->cart->clear();
                unset($this->session->data['order_id']);
                unset($this->session->data['payment_method']);
                unset($this->session->data['payment_methods']);
                unset($this->session->data['shipping_method']);
                unset($this->session->data['shipping_methods']);
                unset($this->session->data['comment']);
                unset($this->session->data['agree']);
                unset($this->session->data['coupon']);
                unset($this->session->data['reward']);
            }

        } catch (Exception $e) {
            // zmiana statusu transakcji dla zamówienia bez danych nie jest mozliwe
        }

        $this->response->setOutput($this->load->view('extension/cashbill/payment/redirect', $data));
    }

    public function callback()
    {

        if (isset($_GET['userdata']) && $this->isRequestSignatureValid($_GET)) {
            if (strtoupper($_GET['status']) == self::OK_STATUS) {
                $this->response->redirect($this->url->link('checkout/success', '', true));
                return;
            }

            $this->response->redirect($this->url->link('checkout/failure', '', true));
            return;
        }

        if (isset($_POST['userdata']) && $this->isRequestSignatureValid($_POST)) {

            $order_id = $_POST['userdata'];

            $this->load->model('checkout/order');

            $order_info = $this->model_checkout_order->getOrder($order_id);
            $newOrderStatus = $this->config->get('payment_cashbill_order_status_cancel_id');
            $message = 'Klient anulował płatność za zamówienie.';

            if (strtoupper($_POST['status']) == self::OK_STATUS) {
                $message = 'Płatność w kwocie ' . $_POST['amount'] . ' zł została przyjęta przez CashBill. Identyfikator transakcji w systemie CashBill to ' . $_POST['orderid'];
                $newOrderStatus = $this->config->get('payment_cashbill_order_status_id');
            }

            if ($order_info['order_status_id'] != $newOrderStatus) {
                $this->model_checkout_order->addHistory($order_id, $newOrderStatus, $message, false);
            }

            exit("OK");
        }

        $this->response->redirect($this->url->link('checkout/failure', '', true));
    }

    private function isRequestSignatureValid($requestData)
    {
        return $this->generateRequestSignature($requestData) == $requestData['sign'] || $this->generateRequestSignatureV2($requestData) == $requestData['sign'];
    }

    private function generateRequestSignature($requestData)
    {
        return md5($requestData['service'] . $requestData['orderid'] . $requestData['amount'] . $requestData['userdata'] . $requestData['status'] . $this->config->get('payment_cashbill_secret'));
    }

    private function generateRequestSignatureV2($requestData)
    {
        return md5($requestData['service'] . '|' . $requestData['orderid'] . '|' . $requestData['amount'] . '|' . $requestData['userdata'] . '|' . $requestData['status'] . '|' . $this->config->get('payment_cashbill_secret'));
    }

}