<?php

namespace Opencart\Admin\Controller\Extension\CashBill\Payment;
class CashBill extends \Opencart\System\Engine\Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/cashbill/payment/cashbill');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_cashbill', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        if (isset($this->error['secret'])) {
            $data['error_secret'] = $this->error['secret'];
        } else {
            $data['error_secret'] = '';
        }

        if (isset($this->error['pp'])) {
            $data['error_pp'] = $this->error['pp'];
        } else {
            $data['error_pp'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/cashbill/payment/cashbill', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/cashbill/payment/cashbill', 'user_token=' . $this->session->data['user_token'], true);

        $data['back'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

        if (isset($this->request->post['payment_cashbill_title'])) {
            $data['payment_cashbill_title'] = $this->request->post['payment_cashbill_title'];
        } else {
            $data['payment_cashbill_title'] = $this->config->get('payment_cashbill_title');
        }

        if (isset($this->request->post['payment_cashbill_pp'])) {
            $data['payment_cashbill_pp'] = $this->request->post['payment_cashbill_pp'];
        } else {
            $data['payment_cashbill_pp'] = $this->config->get('payment_cashbill_pp');
        }

        if (isset($this->request->post['payment_cashbill_secret'])) {
            $data['payment_cashbill_secret'] = $this->request->post['payment_cashbill_secret'];
        } else {
            $data['payment_cashbill_secret'] = $this->config->get('payment_cashbill_secret');
        }

        if (isset($this->request->post['payment_cashbill_order_status_id'])) {
            $data['payment_cashbill_order_status_id'] = $this->request->post['payment_cashbill_order_status_id'];
        } else {
            $data['payment_cashbill_order_status_id'] = $this->config->get('payment_cashbill_order_status_id');
        }

        if (isset($this->request->post['payment_cashbill_order_status_new_id'])) {
            $data['payment_cashbill_order_status_new_id'] = $this->request->post['payment_cashbill_order_status_new_id'];
        } else {
            $data['payment_cashbill_order_status_new_id'] = $this->config->get('payment_cashbill_order_status_new_id');
        }

        if (isset($this->request->post['payment_cashbill_order_status_cancel_id'])) {
            $data['payment_cashbill_order_status_cancel_id'] = $this->request->post['payment_cashbill_order_status_cancel_id'];
        } else {
            $data['payment_cashbill_order_status_cancel_id'] = $this->config->get('payment_cashbill_order_status_cancel_id');
        }

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        if (isset($this->request->post['payment_cashbill_status'])) {
            $data['payment_cashbill_status'] = $this->request->post['payment_cashbill_status'];
        } else {
            $data['payment_cashbill_status'] = $this->config->get('payment_cashbill_status');
        }

        if (isset($this->request->post['payment_cashbill_sort_order'])) {
            $data['payment_cashbill_sort_order'] = $this->request->post['payment_cashbill_sort_order'];
        } else {
            $data['payment_cashbill_sort_order'] = $this->config->get('payment_cashbill_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/cashbill/payment/cashbill', $data));
    }

    private function validate() {
        if (!$this->user->hasPermission('modify', 'extension/cashbill/payment/cashbill')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['payment_cashbill_pp']) {
            $this->error['pp'] = $this->language->get('error_pp');
        }

        if (!$this->request->post['payment_cashbill_secret']) {
            $this->error['secret'] = $this->language->get('error_secret');
        }

        return !$this->error;
    }
}