<?php

defined('_JEXEC') or die('Restricted access');
require_once(JPATH_ADMINISTRATOR . '/components/com_j2store/library/plugins/payment.php');
require_once(JPATH_ADMINISTRATOR . '/components/com_j2store/helpers/j2store.php');

class plgJ2StorePayment_cashbill extends J2StorePaymentPlugin
{
    public $_element = 'payment_cashbill';

    function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
        $this->loadLanguage('com_j2store', JPATH_ADMINISTRATOR);
    }

    function onJ2StoreIsJ2Store4($element)
    {
        if (!$this->_isMe($element)) {
            return null;
        }
        return true;
    }

    public function _prePayment($data)
    {
        $vars = new JObject();
        $vars->url = JRoute::_("index.php?option=com_j2store&view=checkout");
        $vars->order_id = $data['order_id'];
        $vars->orderpayment_id = $data['orderpayment_id'];
        $vars->orderpayment_type = $this->_element;
        $vars->message = "Po kliknięciu zostaniesz przeniesiony na stronę płatności";

        $html = $this->_getLayout('prepayment', $vars);
        return $html;
    }

    public function _postPayment($data)
    {
        $vars = new JObject();

        $app = JFactory::getApplication();
        $paction = $app->input->getString('paction');

        switch ($paction) {
            case 'status':
                echo $this->_cashBillCallback();
                $app->close();
                break;
            case 'process':
                echo $this->_formCreator($app->input->getArray($_POST));
                $app->close();
                break;
            default:
                $html = $this->_getLayout('message', $vars);
                break;
        }
        return $html;
    }

    public function checkSignature($data, $key, $sign)
    {
        if (md5($data['service'] . $data['orderid'] . $data['amount'] . $data['userdata'] . $data['status'] . $key) === $sign) {
            return true;
        }

        if (md5($data['service'] . '|' . $data['orderid'] . '|' . $data['amount'] . '|' . $data['userdata'] . '|' . $data['status'] . '|' . $key) === $sign) {
            return true;
        }

        return false;
    }

    public function _cashBillCallback()
    {
        if ($this->checkSignature($_POST, $this->params->get('user_key'), $_POST['sign'])) {
            $order_id = $_POST['userdata'];
            $orderpayment = F0FTable::getInstance('Order', 'J2StoreTable')->getClone();
            $orderpayment->load(array('order_id' => $order_id));

            $orderinfo = $orderpayment->getOrderInformation();

            if (strtoupper($_POST['status']) == 'OK') {
                $orderpayment->transaction_details = 'Płatność w kwocie ' . $_POST['amount'] . ' została przyjęta przez CashBill';
                $orderpayment->transaction_id = $_POST['orderid'];
                $orderpayment->transaction_status = 'Płatność przyjęta';
                $orderpayment->update_status($this->params->get('payment_status_success'), true);
                $orderpayment->reduce_order_stock();
            }

            if (strtoupper($_POST['status']) == 'ERR') {
                $orderpayment->transaction_details = 'Płatność nie została zaksięgowana przez CashBill';
                $orderpayment->transaction_id = $_POST['orderid'];
                $orderpayment->transaction_status = 'Płatność nie przyjęta';
                $orderpayment->update_status($this->params->get('payment_status_failed'), true);
            }

            echo 'OK';
            exit();
        }

        echo 'BLAD SYGNATURY';
    }

    public function _formCreator($data)
    {
        $app = JFactory::getApplication();

        if (!$app->getInput()) {
            return '';
        }

        $order = F0FTable::getInstance('Order', 'J2StoreTable')->getClone();
        $order->load($data['orderpayment_id']);
        $orderinfo = $order->getOrderInformation();

        $currency_values = $this->getCurrency($order);
        $amount = J2Store::currency()->format($order->order_total, $currency_values['currency_code'], $currency_values['currency_value'], false);
        $country = $this->getCountryById($orderinfo->billing_country_id)->country_isocode_2;

        $hidden = array(
            'service' => $this->params->get('user_id'),
            'amount' => $amount,
            'currency' => strtoupper($currency_values['currency_code']),
            'desc' => 'Zamówienie nr #' . $order->order_id,
            'lang' => "pl",
            'userdata' => $order->order_id,
            'ref' => 'J2Store',
            'forname' => $orderinfo->billing_first_name,
            'surname' => $orderinfo->billing_last_name,
            'email' => $orderinfo->user_email,
            'tel' => "",
            'street' => $orderinfo->billing_address_1,
            'street_n1' => "",
            'street_n2' => "",
            'city' => $orderinfo->billing_city,
            'postcode' => $orderinfo->billing_zip,
            'country' => $this->getCountryById($orderinfo->billing_country_id)->country_isocode_2
        );

        $sign = md5(implode("|", $hidden) . '|' . $this->params->get('user_key'));
        $hidden['sign'] = $sign;

        $vars = new JObject();
        $vars->url = 'https://pay.cashbill.pl/form/pay.php';
        $vars->data = $hidden;
        $vars->orderpayment_type = $this->_element;
        $order->update_status($this->params->get('payment_status_order'));
        $order->empty_cart();

        return $this->_getLayout('redirect', $vars);
    }

}
